import time
import board
import digitalio

CH1_PIN = board.GP12
CH2_PIN = board.GP13
CH3_PIN = board.GP14
CH4_PIN = board.GP15
CH5_PIN = board.GP19
CH6_PIN = board.GP18
CH7_PIN = board.GP17
CH8_PIN = board.GP16

def relay(pin):
    r = digitalio.DigitalInOut(pin)
    r.direction = digitalio.Direction.OUTPUT
    r.value = True      # （NC close）
    return r

CH1 = relay(CH1_PIN)
CH2 = relay(CH2_PIN)
CH3 = relay(CH3_PIN)
CH4 = relay(CH4_PIN)
CH5 = relay(CH5_PIN)
CH6 = relay(CH6_PIN)
CH7 = relay(CH7_PIN)
CH8 = relay(CH8_PIN)

relays = [CH1, CH2, CH3, CH4, CH5, CH6, CH7, CH8]

while True:
    for ch in relays:
        ch.value = False   # （NO close）
        time.sleep(1)
        ch.value = True    # （NC close）

